﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class DailySalesReport
    {

        public DailySalesReport()
        {

        }

        public DailySalesReport(IDataReader myDataRecord)
        {
            DailyReportID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DailyReportID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("DailyReportID"));
            ReportDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ReportDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ReportDate"));
            CashRegisterBalance = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CashRegisterBalance"))? 0.00M : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("CashRegisterBalance"));
            OpeningBalance = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("OpeningBalance")) ? 0.00M : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("OpeningBalance"));
            MoneyOut = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("MoneyOut")) ? 0.00M : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("MoneyOut"));
            MoneyIn = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("MoneyIn")) ? 0.00M : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("MoneyIn"));
            ReconcileAmount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ReconcileAmount")) ? 0.00M : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("ReconcileAmount"));
            Remarks = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Remarks")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Remarks"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            CreatedBy = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            ModifiedBy = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ModifiedBy"));
            ReportStatus = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ReportStatus")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ReportStatus"));
            OpeningRemarks = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("OpeningBalanceVarianceRemarks")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("OpeningBalanceVarianceRemarks"));
        }

        [DataObjectField(true, false, false)]
        public Guid DailyReportID { get; set; }

        public DateTime ReportDate {get;set;}

        public decimal CashRegisterBalance { get; set; }

        public decimal OpeningBalance{ get; set; }

        public decimal MoneyOut{ get; set; }

        public decimal MoneyIn{ get; set; }

        public decimal ReconcileAmount {get;set;}

        public string Remarks {get;set;}

        public string ReportStatus { get; set; }

        public DateTime ModifiedDate { get; set; }

        public DateTime CreatedDate { get; set; }

        public Guid CreatedBy { get; set; }

        public Guid ModifiedBy { get; set; }

        public string OpeningRemarks { get; set; }

    }
}
